# todo this module eventually should be looked into being combined/extended to create a base page with page_helper.rb
module Capybara
  class Session
    def has_iframe?(src)
      has_selector?("iframe[name='#{src}']")
    end
  end
end

# Disable Rubocop to be consistent with Capybara's spacing
# rubocop:disable IndentationWidth
# rubocop:disable EndAlignment

# This patch was designed for Capybara 2.11.0
# Breaks out the uri, and will only call .path and .request_uri if uri is not nil
# Fix pending, SMOC-405
module CapybaraURIPatch
  def resolves_for?(session)
    @actual_path = if options[:url]
                     session.current_url
     else
       uri = ::Addressable::URI.parse(session.current_url)
       if options[:only_path]
         uri.path unless uri.nil?
       else
         uri.request_uri unless uri.nil?
       end
     end

    if @expected_path.is_a? Regexp
      @actual_path.match(@expected_path)
    else
      ::Addressable::URI.parse(@expected_path) == Addressable::URI.parse(@actual_path)
    end
  end
end

Capybara::Queries::CurrentPathQuery.prepend CapybaraURIPatch
