require_relative 'environment_config'

class KrakenEnvironment < EnvironmentConfig

  class << self

    attr_reader :url

    # Configures Kraken Environment and stores the URL
    # @param [String] environment The environment name
    def initialize(environment)
      @url = host_url(environment)
    end

    # This method does not maintain state.
    # Use initialize() to set an environment and refer to be able to refer to the FQDN elsewhere.
    # @param [String] environment The environment name
    # @return [String] The fully qualified domain name of the specified environment
    def host_url(environment)
      case environment
        when 'production'
          return production_host
        when 'local'
          return local_host
        else
          return staging_host(environment)
      end
    end

    # @return [String] Web production fully qualified domain name
    private def production_host
      return 'https://api.twitch.tv/kraken'
    end

    # @return [String] Localhost fully qualified domain name
    private def local_host
      'http://localhost.twitch.tv:3000/kraken'
    end

    # @param [String] environment The staging environment
    # @return [String] Staging fully qualified domain name
    private def staging_host(environment)
      return "https://#{environment}-api.dev.us-west2.twitch.tv/kraken"
    end
  end

end
