require_relative 'environment_config'
require_relative 'web_environment'

class PassportEnvironment < EnvironmentConfig

  class << self

    attr_reader :url

    # Configures Passport Environment and stores the URL
    # @param [String] environment The environment name
    def initialize(environment)
      @url = host_url(environment)
    end

    # This method does not maintain state.
    # Use initialize() to set an environment and refer to be able to refer to the FQDN elsewhere.
    # @param [String] environment The environment name
    # @return [String] The fully qualified domain name of the specified environment
    def host_url(environment)
      case environment
        when 'production'
          return production_host
        else
          return staging_host(environment)
      end
    end

    # @return [String] Passport production fully qualified domain name
    private def production_host
      return 'https://passport.twitch.tv'
    end

    # @param [String] environment The Passport staging environment
    # @return [String] Passport staging fully qualified domain name
    private def staging_host(environment)
      return "https://passport-#{environment}.internal.twitch.tv"
    end
  end
end
