require_relative 'environment_config'
require './core/data/player_core_data'
require './core/data/spec_data'

class PlayerCoreEnvironment < EnvironmentConfig

  class << self

    attr_reader :url

    # Configure Player Core Environment and stores the URL.
    # if PlayerCoreData.player_core_local is not null, Dev is running a local branch for testing else
    # the player core url is created using a branch name.
    def initialize
      if !PlayerCoreData.player_core_local.nil?
        @url = validate_player_core_local_environment
      else
        PlayerCoreData.player_core_url = "#{PlayerCoreData.player_core_base}#{PlayerCoreData.player_core_branch}"
      end
      @url = PlayerCoreData.player_core_url
    end

    # If player_core_url is specified and grid is set to false, local development url will be used.
    private def validate_player_core_local_environment
      if SpecData.grid.to_s == 'false'
        return PlayerCoreData.player_core_local
      elsif SpecData.grid.to_s == 'true'
        raise "'GRID' must equal 'false' for parameter 'player_core_local' to work."
      end
    end

  end

end
