require 'yaml'

# properties_config.rb handles all YAML based
# configurations. Currently, only setup for video player
# parameters.
class PropertiesConfig
  @prop_conf = {} # Contains prooperties from property file
  @sys_conf = {} # Contains properties from the system (commandline/Jenkins)

  class << self
    attr_reader :prop_conf, :sys_conf

    def property_config(config_file)
      properties = YAML.load_file("core/configs/property_configs/#{config_file}")

      # prop_conf is for properties managed from the Properties file
      @prop_conf[:GRID] = properties['GRID'] # parameter read as TrueClass
      @prop_conf[:GRID_HOST] = properties['GRID_HOST']
      @prop_conf[:GRID_USERNAME] = properties['GRID_USERNAME']
      @prop_conf[:GRID_ACCESS_KEY] = properties['GRID_ACCESS_KEY']
      @prop_conf[:BMP] = properties['BMP'] # parameter read as TrueClass
      @prop_conf[:TEST_SUITE] = properties['TEST_SUITE']
      @prop_conf[:BROWSER] = properties['BROWSER']
      @prop_conf[:BROWSER_VERSION] = properties['BROWSER_VERSION']
      @prop_conf[:OS_PLATFORM] = properties['OS_PLATFORM']
      @prop_conf[:OS_VERSION] = properties['OS_VERSION']

      @prop_conf[:RETRY_COUNT] = properties['RETRY_COUNT']

      @prop_conf[:PLAYER_ENVIRONMENT] = properties['PLAYER_ENVIRONMENT']
      @prop_conf[:PLAYER_TYPE] = properties['PLAYER_TYPE']
      @prop_conf[:PLAYER_BRANCH] = properties['PLAYER_BRANCH']
      @prop_conf[:PLAYER_CHANNEL] = properties['PLAYER_CHANNEL']
      @prop_conf[:PLAYER_VOD] = properties['PLAYER_VOD']
      @prop_conf[:PLAYER_DOMAIN] = properties['PLAYER_DOMAIN']
      @prop_conf[:PLAYER_DOMAIN_URL] = properties['PLAYER_DOMAIN_URL']

      @prop_conf[:PLAYER_CORE_LOCAL] = properties['PLAYER_CORE_LOCAL']
      @prop_conf[:PLAYER_CORE_BASE] = properties['PLAYER_CORE_BASE']
      @prop_conf[:PLAYER_CORE_BRANCH] = properties['PLAYER_CORE_BRANCH']
      @prop_conf[:PLAYER_CORE_DOMAIN_FOR_VOD] = properties['PLAYER_CORE_DOMAIN_FOR_VOD']

      # Sauce Labs
      @prop_conf[:SAUCELABS_USER] = properties['SAUCELABS_USER']
      @prop_conf[:SAUCELABS_KEY]  = properties['SAUCELABS_KEY']
      @prop_conf[:LOCAL_TESTING] = properties['LOCAL_TESTING']
      @prop_conf[:SAUCE_TUNNEL_ID] = properties['SAUCE_TUNNEL_ID']

      # Shared (External Grid)
      @prop_conf[:SCREEN_RESOLUTION] = properties['SCREEN_RESOLUTION']

      # Web
      @prop_conf[:ENVIRONMENT] = properties['ENVIRONMENT']
      @prop_conf[:TIER2] = properties['TIER2']
      @prop_conf[:PARALLEL] = properties['PARALLEL']

      ##########
      # sys_conf is for properties received via commandline / Jenkins
      ##########

      # Cross Browser Grid
      @sys_conf[:GRID] = ENV['GRID'] # parameter read as TrueClass
      @sys_conf[:GRID_HOST] = ENV['GRID_HOST']
      @sys_conf[:GRID_USERNAME] = ENV['GRID_USERNAME']
      @sys_conf[:GRID_ACCESS_KEY] = ENV['GRID_ACCESS_KEY']

      @sys_conf[:BMP] = ENV['BMP'] # parameter read as TrueClass
      @sys_conf[:TEST_SUITE] = ENV['TEST_SUITE']
      @sys_conf[:BROWSER] = ENV['BROWSER']
      @sys_conf[:BROWSER_VERSION] = ENV['BROWSER_VERSION']
      @sys_conf[:OS_PLATFORM] = ENV['OS_PLATFORM']
      @sys_conf[:OS_VERSION] = ENV['OS_VERSION']

      @sys_conf[:RETRY_COUNT] = ENV['RETRY_COUNT']

      @sys_conf[:PLAYER_ENVIRONMENT] = ENV['PLAYER_ENVIRONMENT']
      @sys_conf[:PLAYER_TYPE] = ENV['PLAYER_TYPE']
      @sys_conf[:PLAYER_BRANCH] = ENV['PLAYER_BRANCH']
      @sys_conf[:PLAYER_CHANNEL] = ENV['PLAYER_CHANNEL']
      @sys_conf[:PLAYER_VOD] = ENV['PLAYER_VOD']
      @sys_conf[:PLAYER_DOMAIN] = ENV['PLAYER_DOMAIN']
      @sys_conf[:PLAYER_DOMAIN_URL] = ENV['PLAYER_DOMAIN_URL']

      @sys_conf[:PLAYER_CORE_LOCAL] = ENV['PLAYER_CORE_LOCAL']
      @sys_conf[:PLAYER_CORE_BASE] = ENV['PLAYER_CORE_BASE']
      @sys_conf[:PLAYER_CORE_BRANCH] = ENV['PLAYER_CORE_BRANCH']
      @sys_conf[:PLAYER_CORE_DOMAIN_FOR_VOD] = ENV['PLAYER_CORE_DOMAIN_FOR_VOD']

      # Sauce Labs
      @sys_conf[:SAUCELABS_USER] = ENV['SAUCELABS_USER']
      @sys_conf[:SAUCELABS_KEY]  = ENV['SAUCELABS_KEY']
      @sys_conf[:LOCAL_TESTING]  = ENV['LOCAL_TESTING']
      @sys_conf[:SAUCE_TUNNEL_ID] = ENV['SAUCE_TUNNEL_ID']

      # Shared (External Grid)
      @sys_conf[:SCREEN_RESOLUTION] = ENV['SCREEN_RESOLUTION']

      # Web
      @sys_conf[:ENVIRONMENT]     = ENV['ENVIRONMENT']
      @sys_conf[:TIER2]           = ENV['TIER2']
      @sys_conf[:PARALLEL]        = ENV['PARALLEL']
    end
  end
end
