module HeimdallExceptions
  class UserNotAvailable < StandardError
    attr_reader :user_type

    def initialize(msg='Specified user type was not available', user_type=nil)
      @user_type = user_type
      super(msg)
    end
  end

  class UserTypeNotFound < StandardError
    attr_reader :user_type

    def initialize(msg='Specified user type was not available', user_type=nil)
      @user_type = user_type
      super(msg)
    end
  end

  class UUIDMismatch < StandardError
    def initialize(expected_uuid=nil, received_uuid=nil)
      msg = 'The UUIDs did not match.'
      msg += " Expected UUID: #{expected_uuid}." unless expected_uuid.nil?
      msg += " Got UUID: #{received_uuid}." unless received_uuid.nil?
      super(msg)
    end
  end
end
