require './core/utils/js_logger_utils'

# Adds RSpec formatter to print JS console and client logs
# Supports Chrome Browser Only
class JSLogFormatter
  RSpec::Core::Formatters.register self, :example_passed, :example_failed

  include JSLoggerUtils

  def initialize(output)
    # This is needed for the rspec formatter to register
  end

  # Fetch client and browser logs for passed example but not print
  # Clears the previous logs for both client andd browser
  def example_passed(notification)
    JSLoggerUtils::JSErrorLogger.get_logs
  end

  # Fetch client and browser logs for failed scenario and print it on screen
  def example_failed(notification)
    JSLoggerUtils::JSErrorLogger.get_logs
    puts JSLoggerUtils::JSErrorLogger.filtered_logs
  end
end
