require './core/base/page_helper'

module PlayerUIEvents
  # @param playback_duration [Integer] Duration for which stream will be validated
  # @return [Boolean] True, if smooth playback for whole stream
  def smooth_playhead?(duration = nil)
    duration ||= page.evaluate_script("player.getDuration();")
    smooth_play_js = File.open('./core/js/smooth_playback.js').read
    smooth_play_js.gsub! '#{duration}', "#{duration}"
    response = TwitchUtils.execute_event_listener_script(smooth_play_js, duration + 5)
    if response.is_a? Hash
      puts "[ERROR] #{response['message']}" unless response['success']
      return response['success']
    end
    return response
  end

  # @param fps [Integer] Expected FPS of stream
  # @param playback_duration [Integer] Duration for which stream will be validated
  # @return [Boolean] True, if smooth playback for the whole stream
  def smooth_fps?(fps, playback_duration=nil)
    playback_duration ||= page.evaluate_script("player.getDuration();")
    smooth_fps_js = File.open('./core/js/smooth_fps.js').read
    smooth_fps_js.gsub! '#{playback_duration}', "#{playback_duration}"
    smooth_fps_js.gsub! '#{fps}', "#{fps}"
    response = TwitchUtils.execute_event_listener_script(smooth_fps_js, playback_duration + 5)
    if response.is_a? Hash
      puts "[ERROR] #{response['message']}" unless response['success']
      return response['success']
    end
    return response
  end
end
