require './core/base/page_helper'

class TopNav < PageHelper
  # Class declarations
  @container = '.top-nav'
  @twitch_logo = '.js-top-nav-logo'
  @overflow = '.js-top-nav-overflow'
  @search = '.js-top-nav-search'
  @dropdown = '.js-top-nav-user-card'
  @container_old = '#site_header' # Cross compatibility with the older Top Nav
  @browse = 'Browse'

  class << self
    attr_reader :container, :twitch_logo, :overflow, :search, :dropdown, :container_old

    def navigate_to
      visit "/"
    end

    def visible?
      return page.has_css?(@container, wait: wait_time)
    end

    # Method to return the Top Nav Bar, cross compatible with both the new and old
    # @return [Capybara::Element] The Top Nav Bar
    def element
      return find(@container)
    end

    # @return [Capybara::Element] The element for the Top Navigation Following Link
    def following_link
      within self.element do
        return find_link 'Following'
      end
    end

    # @return [Capybara::Element] The Log In Link on the Top Navigation Bar
    def log_in_link
      within self.element do
        return find_link('Log In')
      end
    end

    def navigate_to_directory
      click_on @browse
    end

    # Certain browsers have longer wait times for the Top Navigation
    # @return [Int] The duration to search for elements
    private def wait_time
      if page.driver.browser.browser == :MicrosoftEdge
        return 5
      else
        return Capybara.default_max_wait_time
      end
    end
  end
end
