# DEPRECATION NOTICE
# This module is attempting to be deprecated
# Please make any updates to SignupModal in signup_modal.rb

require './core/twitch/web/passport/login_page'

module SignupPage
  # Someone messy implementation, but only want to change it once.
  # This already exists in LoginPage, so pull from that method.
  # That way we don't have to include LoginPage methods in all signup scenarios
  include LoginPage

  # Purpose is to be able to generate a unique username based on time
  # @return String of the username, in the format of qa_TIMESTAMP
  def generate_username
    return Time.now.strftime('qa_%-m%-d%y%H%M%S')
  end

  # Allows variables to be used in the scope of other methods within the module
  def init_variables
    @passport_frame = 'passport'
    @username_field_name = 'username'
    @password_field_name = 'password'
    @birthday_month_css = '.dropdown.month_contain'
    @birthday_day_css = '.dropdown.day_contain'
    @birthday_year_css = '.dropdown.year_contain'
    @email_field_name = 'email'

    @username_validator_css = '.username-container .login-available'
    @password_validator_css = '.password-container .login-available'
    @email_validator_css = '.email-container .login-available'
  end

  # Purpose of this method is to fill in the sign up fields with whatever information you please.
  # Possible to exclude an input to determine the effects
  # @param options Type Hash - Allows for the following arguments:
  # :username
  # :password
  # :month
  # :day
  # :year
  # :email
  # @param defaults Type Boolean - Auto-fill non-specified option fields
  # @return Hash containing the parameters that were filled into the form
  def fill_in_fields(defaults, options = {})
    init_variables()

    param_options = options
    param_options = set_default_signup(param_options) if defaults == true

    begin
      fill_in @username_field_name, :with => param_options[:username] if param_options.has_key?(:username)
      fill_in @password_field_name, :with => param_options[:password] if param_options.has_key?(:password)

      # http://stackoverflow.com/questions/20134085/how-to-select-option-in-drop-down-using-capybara

      within(@birthday_month_css) do
        find(param_options[:month]).select_option if param_options.has_key?(:month)
      end

      within(@birthday_day_css) do
        find(param_options[:day]).select_option if param_options.has_key?(:day)
      end

      within(@birthday_year_css) do
        find(param_options[:year]).select_option if param_options.has_key?(:year)
      end

      fill_in @email_field_name, :with => param_options[:email] if param_options.has_key?(:email)
    rescue Exception => e
      raise e if e.message != 'Unable to find field "username"' # If it's a modal, it needs to be within the passport frame

      # Make sure the iframe loads before trying to enter it
      within '.js-login-popup' do
        find('iframe', wait: 6) # This is Passport. Give it 6 seconds to load
      end

      within_frame @passport_frame do
        fill_in @username_field_name, :with => param_options[:username] if param_options.has_key?(:username)
        fill_in @password_field_name, :with => param_options[:password] if param_options.has_key?(:password)

        # http://stackoverflow.com/questions/20134085/how-to-select-option-in-drop-down-using-capybara

        within(@birthday_month_css) do
          find(param_options[:month]).select_option if param_options.has_key?(:month)
        end

        within(@birthday_day_css) do
          find(param_options[:day]).select_option if param_options.has_key?(:day)
        end

        within(@birthday_year_css) do
          find(param_options[:year]).select_option if param_options.has_key?(:year)
        end

        fill_in @email_field_name, :with => param_options[:email] if param_options.has_key?(:email)
      end
    end

    return param_options
  end

  # Checks the Sign Up Page validation icons
  # @param username - Boolean of whether the username validator should be true or false
  # @param password - Boolean of whether the password validator should be true or false
  # @param email - Boolean of whether the email validator should be true or false
  # Optionally, can pass nil if the validator should not be checked (i.e., if it doesn't exist)
  def validator_expectation(username, password, email)
    # Validators Visually Indicate Whether The Input Is Valid

    # By using finders, Capybara will auto wait for them to show up. Reduces the need to wait
    username_field = find(@username_validator_css) if username != nil
    password_field = find(@password_validator_css) if password != nil
    email_field = find(@email_validator_css) if email != nil
    # Have to assume nth-of-type 1 = username, 2 = password, 4 = email
    # Also no way to determine field is valid other than its SRC
    # Improvement ticketed at ID-199
    expect(username_field['src'].include?('ok')).to eq(username) if username != nil # Username Validator
    expect(password_field['src'].include?('ok')).to eq(password) if password != nil # Password Validator
    expect(email_field['src'].include?('ok')).to eq(email) if email != nil # Email Validator
  end

  # @return Capybara::Node::Element of the Sign Up button, whether it is enabled or disabled
  def get_signup_button
    return find('button.js-signup-button')
  end

  # Clicks on the Sign Up Button. Will wait for the button to be enabled (unlike get_signup_button)
  def click_signup_button
    within_frame(@passport_frame) do
      click_button 'Sign Up'
    end
  end

  # This allows you to be able to either use all default values, or pass in a username and use defaults for everything else
  # @param options - Hash of the options to user wants to override and pass into the sign up fields
  # @return Hash of the default field options that were not included
  def set_default_signup(options)
    current_year = 2 # Sign Up Year Form: option:nth-child(2).
    # Assigning this so you can go current_year + 12 to indicate 12 years old
    fifteen_years = "option:nth-child(#{current_year + 15})"

    default_birthdate_option = 'option:nth-child(4)'

    options[:username] = generate_username() if !options.has_key?(:username)
    options[:password] = 'L3tsTw1tch' if !options.has_key?(:password)
    options[:month] = default_birthdate_option if !options.has_key?(:month)
    options[:day] = default_birthdate_option if !options.has_key?(:day)
    options[:year] = fifteen_years if !options.has_key?(:year)
    options[:email] = 'qa.automation@gmail.com' if !options.has_key?(:email)

    return options
  end

  # A simple get method to return the captcha bypass cookie
  def get_captcha_bypass_cookie_name_signup
    return get_captcha_bypass_cookie_name
  end

  # Add a cookie to Passport to bypass captcha
  def set_bypass_captcha_cookie
    visit '/signup'
    expect(page).to have_css('html') # Wait for the page to load before setting the cookie. SMOC-102
    PageHelper.add_cookie(get_captcha_bypass_cookie_name_signup, '1')
  end
end
