require './core/configs/bmp_config'

module BmpUtils

  # Creates a WebDriver Proxy object to pass to a Selenium driver
  # http://www.seleniumhq.org/docs/04_webdriver_advanced.jsp
  # @return Selenium::WebDriver::Proxy Proxy Object to pass to the Selenium Driver
  def create_webdriver_proxy
    proxy = get_proxy
    proxy_addr = proxy.proxy_full_address

    return Selenium::WebDriver::Proxy.new(
        :http => proxy_addr,
        :ftp => proxy_addr,
        :ssl => proxy_addr
    )
  end

  # Create a new proxy if one does not already exist
  def configure_proxy
    @@bmp = BmpConfig.new unless proxy_exists?
    # Only create a proxy if it doesn't already exist
  end

  # Access the proxy object
  # @return BmpConfig A Browsermob Proxy Object
  def get_proxy
    if proxy_exists?
      return @@bmp
    else
      # Proxy doesn't yet exist. Return the proxy
      configure_proxy
      return @@bmp
    end
  end

  # @return Boolean Whether or not a proxy already exists
  def proxy_exists?
    # defined? either returns nil, or a class type
    # returning boolean for these conditions
    if defined? @@bmp
      return true
    else
      return false
    end
  end

  # @return Boolean Whether or not BMP has been enabled
  def bmp_enabled?
    ENV['BMP'] == 'true'
  end

end
