module JSUtils
  # @param [Capybara::Element] Element to scroll upto
  def scroll_to(element)
    script = <<-JS
    arguments[0].scrollIntoView(true);
    JS
    Capybara.current_session.driver.browser.execute_script(script, element.native)
  end

  # @param [String] Css of element to scroll
  # @return [String] JavaScript to be execute by driver
  def scroll_to_bottom(element_css)
    scroll_script = <<-EOS
      var mainCol = document.querySelector('#{element_css}')
      $('#{element_css}')[0].scrollTop = mainCol.scrollHeight
    EOS
    return scroll_script
  end

  # @param [String] Css of element to scroll
  # @return [String] JavaScript to be execute by driver
  def scroll_to_top(element_css)
    scroll_script = <<-EOS
      var mainCol = document.querySelector('#{element_css}')
      $('#{element_css}')[0].scrollTop = -mainCol.scrollHeight
    EOS
    return scroll_script
  end
end
