require 'httparty'
require './core/utils/logger_utils'
require './core/configs/environment/kraken_environment'
require 'json'

class KrakenUtils

  class << self

    # @return [Hash] Live Stream Data
    def live_streams
      endpoint = "#{KrakenEnvironment.url}/streams/"
      logger.debug "[KrakenUtils] -> #{endpoint}"
      response = HTTParty.get(endpoint, headers: {'Accept' => 'application/vnd.twitchtv.v5+json',
                                                  'Client-ID' => '7j65feoxl6nd7q7c5jt7uu61j60eqhp'})
      logger.debug "[KrakenUtils] <- (#{response.code}) #{endpoint}"

      if response.code == 200
        return JSON.parse(response.body)
      else
        logger.warn "Request to #{endpoint} returned #{response.code}: #{response.body}"
        return {}
      end
    end

    # @return [Array] Usernames of all live channels
    def live_stream_usernames
      streams = live_streams
      stream_usernames = []

      if !streams.has_key?('streams')
        logger.warn "Streams key was not found in #{streams}"
        return stream_usernames
      end

      streams['streams'].each { |stream| stream_usernames << stream['channel']['name'] }
      return stream_usernames
    end
  end
end
