require 'logger'

module LoggerUtils

  class SmocaLogger

    class << self

      # @return [Logger] The Logger object
      def logger
        @logger ||= Logger.new(STDERR)
      end

      # Sets the log level
      # @param log_level [Symbol] The level to log
      def level=(log_level=:info)
        logger.level = log_level_class(log_level)
      end

      # @param log_level [Symbol] The log level
      # @return The appropriate logger level class
      private def log_level_class(log_level)
        case log_level.downcase
          when :debug
            return Logger::DEBUG
          when :info
            return Logger::INFO
          when :warn
            return Logger::WARN
          when :error
            return Logger::ERROR
          when :fatal
            return Logger::FATAL
          when :unknown
            return Logger::UNKNOWN
          else
            raise "Did not recognize log level #{log_level}"
        end
      end

    end

  end

  # @return [Logger] The logger object to work with
  def logger
    return LoggerUtils::SmocaLogger.logger
  end

end
