require './core/configs/properties_config'
require './core/data/video_player_data'
require './core/data/player_core_data'
require './core/data/spec_data'
require 'smoca_common/utils/twitch_utils'

# PropertiesConfigUtils will evalutate both enviornment and system properties.
# Environment properties are ones that are given via Property Config File.
# System properties are ones that are given via commandline or Jenkins.
# To accomodate Jenkins, system prooperties are given priority over property file parameters.
class PropertiesConfigUtils

  PropertiesConfig.property_config(ENV['PROPERTIES'])
  def self.configure_environment
    # if systemp parameters are empty, use enviornment properties

    # Shared
    grid = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:GRID]) ?
    PropertiesConfig.prop_conf[:GRID] : PropertiesConfig.sys_conf[:GRID]

    grid_host = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:GRID_HOST]) ?
    PropertiesConfig.prop_conf[:GRID_HOST] : PropertiesConfig.sys_conf[:GRID_HOST]

    grid_username = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:GRID_USERNAME]) ?
    PropertiesConfig.prop_conf[:GRID_USERNAME] : PropertiesConfig.sys_conf[:GRID_USERNAME]

    grid_access_key = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:GRID_ACCESS_KEY]) ?
    PropertiesConfig.prop_conf[:GRID_ACCESS_KEY] : PropertiesConfig.sys_conf[:GRID_ACCESS_KEY]

    bmp = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:BMP]) ?
    PropertiesConfig.prop_conf[:BMP] : PropertiesConfig.sys_conf[:BMP]

    test_suite = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:TEST_SUITE]) ?
    PropertiesConfig.prop_conf[:TEST_SUITE] : PropertiesConfig.sys_conf[:TEST_SUITE]

    browser = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:BROWSER]) ?
    PropertiesConfig.prop_conf[:BROWSER] : PropertiesConfig.sys_conf[:BROWSER]

    browser_version = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:BROWSER_VERSION]) ?
    PropertiesConfig.prop_conf[:BROWSER_VERSION] : PropertiesConfig.sys_conf[:BROWSER_VERSION]

    os_platform = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:OS_PLATFORM]) ?
    PropertiesConfig.prop_conf[:OS_PLATFORM] : PropertiesConfig.sys_conf[:OS_PLATFORM]

    os_version = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:OS_VERSION]) ?
    PropertiesConfig.prop_conf[:OS_VERSION] : PropertiesConfig.sys_conf[:OS_VERSION]

    retry_count = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:RETRY_COUNT]) ?
    PropertiesConfig.prop_conf[:RETRY_COUNT] : PropertiesConfig.sys_conf[:RETRY_COUNT]

    # Web
    environment = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:ENVIRONMENT]) ?
    PropertiesConfig.prop_conf[:ENVIRONMENT] : PropertiesConfig.sys_conf[:ENVIRONMENT]

    tier2 = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:TIER2]) ?
    PropertiesConfig.prop_conf[:TIER2] : PropertiesConfig.sys_conf[:TIER2]

    parallel = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:PARALLEL]) ?
    PropertiesConfig.prop_conf[:PARALLEL] : PropertiesConfig.sys_conf[:PARALLEL]

    # Player
    player_environment = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:PLAYER_ENVIRONMENT]) ?
    PropertiesConfig.prop_conf[:PLAYER_ENVIRONMENT] : PropertiesConfig.sys_conf[:PLAYER_ENVIRONMENT]

    player_type = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:PLAYER_TYPE]) ?
    PropertiesConfig.prop_conf[:PLAYER_TYPE] : PropertiesConfig.sys_conf[:PLAYER_TYPE]

    player_branch = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:PLAYER_BRANCH]) ?
    PropertiesConfig.prop_conf[:PLAYER_BRANCH] : PropertiesConfig.sys_conf[:PLAYER_BRANCH]

    player_channel = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:PLAYER_CHANNEL]) ?
    PropertiesConfig.prop_conf[:PLAYER_CHANNEL] : PropertiesConfig.sys_conf[:PLAYER_CHANNEL]

    player_vod = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:PLAYER_VOD]) ?
    PropertiesConfig.prop_conf[:PLAYER_VOD] : PropertiesConfig.sys_conf[:PLAYER_VOD]

    player_domain_url = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:PLAYER_DOMAIN_URL]) ?
    PropertiesConfig.prop_conf[:PLAYER_DOMAIN_URL] : PropertiesConfig.sys_conf[:PLAYER_DOMAIN_URL]

    player_domain = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:PLAYER_DOMAIN]) ?
    PropertiesConfig.prop_conf[:PLAYER_DOMAIN] : PropertiesConfig.sys_conf[:PLAYER_DOMAIN]

    player_domain_url = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:PLAYER_DOMAIN_URL]) ?
    PropertiesConfig.prop_conf[:PLAYER_DOMAIN_URL] : PropertiesConfig.sys_conf[:PLAYER_DOMAIN_URL]

    player_core_local = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:PLAYER_CORE_LOCAL]) ?
    PropertiesConfig.prop_conf[:PLAYER_CORE_LOCAL] : PropertiesConfig.sys_conf[:PLAYER_CORE_LOCAL]

    player_core_base = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:PLAYER_CORE_BASE]) ?
    PropertiesConfig.prop_conf[:PLAYER_CORE_BASE] : PropertiesConfig.sys_conf[:PLAYER_CORE_BASE]

    player_core_branch = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:PLAYER_CORE_BRANCH]) ?
    PropertiesConfig.prop_conf[:PLAYER_CORE_BRANCH] : PropertiesConfig.sys_conf[:PLAYER_CORE_BRANCH]

    player_core_domain_for_vod = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:PLAYER_CORE_DOMAIN_FOR_VOD]) ?
    PropertiesConfig.prop_conf[:PLAYER_CORE_DOMAIN_FOR_VOD] : PropertiesConfig.sys_conf[:PLAYER_CORE_DOMAIN_FOR_VOD]

    # Sauce Labs

    saucelabs_user = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:SAUCELABS_USER]) ?
    PropertiesConfig.prop_conf[:SAUCELABS_USER] : PropertiesConfig.sys_conf[:SAUCELABS_USER]

    saucelabs_key = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:SAUCELABS_KEY]) ?
    PropertiesConfig.prop_conf[:SAUCELABS_KEY] : PropertiesConfig.sys_conf[:SAUCELABS_KEY]

    local_testing = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:LOCAL_TESTING]) ?
    PropertiesConfig.prop_conf[:LOCAL_TESTING] : PropertiesConfig.sys_conf[:LOCAL_TESTING]

    sauce_tunnel_id = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:SAUCE_TUNNEL_ID]) ?
    PropertiesConfig.prop_conf[:SAUCE_TUNNEL_ID] : PropertiesConfig.sys_conf[:SAUCE_TUNNEL_ID]

    # Shared (External Grid)

    screen_resolution = TwitchUtils.nil_or_empty?(PropertiesConfig.sys_conf[:SCREEN_RESOLUTION]) ?
    PropertiesConfig.prop_conf[:SCREEN_RESOLUTION] : PropertiesConfig.sys_conf[:SCREEN_RESOLUTION]

    SpecData.grid = grid
    SpecData.grid_host = grid_host
    SpecData.grid_username = grid_username
    SpecData.grid_access_key = grid_access_key
    SpecData.bmp = bmp
    SpecData.test_suite = test_suite
    SpecData.browser = browser.downcase

    # Set Browser Version, if not provided, set it to nil
    if TwitchUtils.nil_or_empty?(browser_version)
      SpecData.browser_version = nil
    else
      SpecData.browser_version = browser_version.to_s
    end

    SpecData.os_platform = os_platform
    SpecData.os_version = os_version
    SpecData.retry_count = retry_count

    SpecData.environment     = environment
    SpecData.tier2           = tier2
    SpecData.parallel        = parallel

    # Sauce Labs

    SpecData.saucelabs_user = saucelabs_user
    SpecData.saucelabs_key  = saucelabs_key
    # Converted to_s as prop_conf are boolean, but sys_conf is a string due to being read from an ENV Var.
    # TODO: Should convert these to a boolean in sys_conf.
    SpecData.local_testing = local_testing.to_s
    SpecData.sauce_tunnel_id = sauce_tunnel_id

    # Shared (External Grid)
    SpecData.screen_resolution = screen_resolution

    VideoPlayerData.player_environment = player_environment
    VideoPlayerData.player_type = player_type
    VideoPlayerData.player_branch = player_branch
    VideoPlayerData.player_channel = player_channel
    VideoPlayerData.player_vod = player_vod
    VideoPlayerData.player_domain = player_domain
    VideoPlayerData.player_domain_url = player_domain_url

    PlayerCoreData.player_core_local = player_core_local
    PlayerCoreData.player_core_base = player_core_base
    PlayerCoreData.player_core_branch = player_core_branch
    PlayerCoreData.player_core_domain_for_vod = player_core_domain_for_vod

    # This will remain until web/web converts to Properties Configurations
    # For now it will only affect video player test.
    ENV['GRID'] = SpecData.grid.to_s
    ENV['GRID_HOST'] = SpecData.grid_host
    ENV['BMP'] = SpecData.bmp.to_s
    ENV['TEST_SUITE'] = SpecData.test_suite
    ENV['BROWSER'] = SpecData.browser
    ENV['BROWSER_VERSION'] = SpecData.browser_version.to_s
    ENV['OS_PLATFORM'] = SpecData.os_platform
    ENV['OS_VERSION'] = SpecData.os_version.to_s

    ENV['RETRY_COUNT'] = SpecData.retry_count.to_s
    ENV['ENVIRONMENT'] = SpecData.environment
    ENV['TIER2']       = SpecData.tier2.to_s
    ENV['PARALLEL']    = SpecData.parallel.to_s
  end
end
