require 'csv'

module SummaryWriterUtils
  # This Module serves to write Test Data to a CSV File

  # CSV File Column Structure
  # Failed Example, Pending Example, Test Duration, Successful Login, Failed Login

  # @return String - the file & file path to write and read from
  def get_summary_file_path
    return 'resources/output/summary.csv'
  end

  # @return Failed test scenarios
  def get_failures
    return get_data('failure')
  end

  # @param failure_message - Type String - The failure message to write to the file
  def write_failure(failure_message)
    write_data('failure', failure_message)
  end

  # @return Pending scenarios
  def get_pending
    return get_data('pending')
  end

  # @param pending_message - Type String - The Pending message to write to the file
  def write_pending(pending_message)
    write_data('pending', pending_message)
  end

  # @return The amount of time it took the test to take
  def get_test_duration
    return get_data('test_duration')
  end

  # @param amount - Type Float/Fixnum/String. Doesn't really matter
  def write_test_duration(amount)
    write_data('test_duration', amount)
  end

  # @return The amount of successful logins
  def get_login_success
    return get_data('login_success')
  end

  # @param amount - Type Float/Fixnum/String. Doesn't really matter
  def write_login_success(amount)
    write_data('login_success', amount)
  end

  # @return The amount of failed logins
  def get_login_failure
    return get_data('login_fail')
  end

  # @param amount - Type Float/Fixnum/String. Doesn't really matter
  def write_login_failure(amount)
    write_data('login_fail', amount)
  end

  private

  # @param type - String for the data you would like to obtain
  # @return - Type Array, an array that includes all of the requested data
  def get_data(type)
    data = Array.new

    read_file().each do |row|
      # TODO: Figure out why row[0] gets nil results and row[1] gets '' results
      if type == 'failure'
        data << row[0] if row[0] != '' && row[0] != nil # Only input non-empty cells
      elsif type == 'pending'
        data << row[1] if row[1] != '' && row[1] != nil # Only input non-empty cells
      elsif type == 'test_duration'
        data << row[2].to_f if row[2] != '' && row[2] != nil # Only input non-empty cells
      elsif type == 'login_success'
        data << row[3] if row[3] != '' && row[3] != nil # Only input non-empty cells
      elsif type == 'login_fail'
        data << row[4] if row[4] != '' && row[4] != nil # Only input non-empty cells
      else
        raise "Unknown type: #{type}"
      end
    end

    return data
  end

  # @param type - Type String, the type of data you would like to write
  # @param data - Type String, the data output you would like to add to the summary file
  def write_data(type, data)
    CSV.open(get_summary_file_path, 'a+') do |csv| # a+ means append and write. Does not overwrite data.
      if type == 'failure'
        csv << [data]
      elsif type == 'pending'
        csv << ['', data]
      elsif type == 'test_duration'
        csv << ['', '', data]
      elsif type == 'login_success'
        csv << ['', '', '', data]
      elsif type == 'login_fail'
        csv << ['', '', '', '', data]
      else
        raise "Unknown type: #{type}"
      end
    end
  end

  # @return The CSV Contents
  def read_file
    return CSV.read(get_summary_file_path)
  end
end
