## About

[BrowserMob Proxy](https://github.com/lightbody/browsermob-proxy) (commonly referred to as BMP) is a utility that allows us to capture and save network performance data from browsers.

This is a major step in allowing a developer to debug a failure, especially if it is intermittent. Having access to network performance history can be critical.

## Features and Usage

The proxy is controlled via a REST interface. It captures performance data in the HAR format. In addition it can actually control HTTP traffic, such as:

- blacklisting and whitelisting certain URL patterns
- simulating various bandwidth and latency
- remapping DNS lookups
- flushing DNS caching
- controlling DNS and request timeouts
- automatic BASIC authorization

## Twitch Technical Configuration

### Running Proxy on AWS

A BMP server is running on AWS, currently at:
http://bmp.us-west2.justin.tv:9090/proxy

To SSH into this box, you can run:
`ldap@bmp.us-west2.justin.tv` - Replacing `ldap` with your ldap username.

The server is running within a Docker Container. Command to launch BMP:

`docker run --name bmp_server -d -p 9090-9121:9090-9121 docker-registry.internal.justin.tv/qa/browsermob-proxy:2.1.0-beta-5`

`:2.1.0-beta-5` is the image version. You can supply it with any version you'd like.
`-p 9090-9121` opens the ports for the proxy to user.

To view all available versions of BrowserMob Proxy on our docker registry, view:
http://docker-registry.internal.justin.tv/v2/qa/browsermob-proxy/tags/list

### Building New Images

We store our Docker Images within the [qa/docker_images](https://git-aws.internal.justin.tv/qa/docker_images).

See README within that repository to learn how to build images.

### Wrapper

A Ruby wrapper built around the REST API is available within core/classes/bmp_proxy.rb. This allows creating proxies, as well as starting & saving hars.

The browser should be pointing at the IP:Proxy_Port. 9090 is simply for making api calls to BMP.
