# ENV Variables

Traditionally, environment variables are passed in through the command line. They provide options for you to customize how and where smoca will run.

For example, `ENVIRONMENT=qa-1 TIER2=false PARALLEL=false bundle exec rspec` will run tests against the staging environment qa-1, with only essential tests, without running in Parallel.

# Property Configuration

As our suite is growing in the amount of Environment Variables, we now have defined configuration files in [core/configs/property_configs](core/configs/property_configs).

As of June 2016, test that fall under `TEST_SUITE=video_player` will be configured using the respective properties configuration file [core/configs/property_configs/video_player_config.yaml](core/configs/property_configs/video_player_config). To execute test, enter the following:

`PROPERTIES=video_player_config.yaml bundle exec rspec spec/video_player/analytics/tier_1_events/tier1_tracking_spec.rb`

The files specified in `PROPERTIES` variable will act as the users desired environment variables.

If you would like to change a variable, you may do so either via the config file or via command line. For example, [core/configs/property_configs/video_player_config.yaml](core/configs/property_configs/video_player_config) has the default value of `BROWSER: firefox`, say we want the test to run against chrome browser. You could either change `BROWSER: chrome` in the configuration file, or enter the following:

`PROPERTIES=video_player_config.yaml BROWSER=chrome bundle exec rspec spec/video_player/analytics/tier_1_events/tier1_tracking_spec.rb`

**Note the added BROWSER=chrome environment variable following the PROPERTIES variable.**

The logic in [core/configs/properties_config.rb](core/configs/properties_config.rb) and [core/utils/properties_config_utils.rb](core/utils/properties_config_utils.rb) files will take environment variables given via command line / Jenkins as a priority over environment variables found in a configuration file. This will allow Jenkins Jobs to be set to specific scenarios more easily.

# Environment Variable Keys

**The following variables are recommended to be provided: ENVIRONMENT and TIER2.** Everything else should be optional to provide.


| ENV Variable | Description|
| ------------ |-------------|
| ENVIRONMENT | The environment you wish to test against. `local`, `production`, or the staging server, such as `ENVIRONMENT=staging-17`. Production is default if not supplied.|
| TIER2 | true/false. Whether to run extended non-critical tests. Takes longer to run, but more extensive.
| PARALLEL | true/false. Whether to run tests in Parallel. Warning: Browsers will open up. Everywhere. False is default if not supplied.
| BETA | true/false. Whether to run scenarios that have been flakey in the past. Default is false.
| BMP | true/false. **Currently BETA** Whether to route requests through BrowserMob Proxy. False is default if not supplied. [BMP Documentation](browsermob_proxy.md)
| RETRY_COUNT | Integer. How many times to try an example. Default is try once.

##### Variables for production running tests **(please don't supply these unless you know what you're doing)**

| ENV Variable | Description |
| ------------ | ------------|
| TRACKING | true/false. Sends stats on the run to statsd. Default to false.
| GRID | true/false. Whether to point to Selenium Grid. False is default if not supplied.
| GRID_HOST | dev/prod. The Grid Hub to point at. Dev is generally for testing things. Prod is default if not supplied.
| GRID_USERNAME | The username for Cross Browser Grid
| GRID_ACCESS_KEY | The access key for Cross Browser Grid
| CAPYBARA_HEADLESS | true/false. Whether to run the browser headlessly. Default to false. Recommended for Manta.
| BROWSER | firefox/chrome. Which browser to run against. Requires Grid. Currently not established, not recommended to use. Default is firefox.
| BUILD_URL | String. The Jenkins Build URL for sending Slack notifications.
| BMP_BLACKLIST | true/false. Whether to blacklist a predefined list of requests through BrowserMob Proxy

##### Variables specific to Sauce Labs
| ENV Variable | Description |
| ------------ | ------------|
| BROWSER | String. [Firefox, Chrome, Edge 13, Safari, IE 11]
| BROWSER_VERSION | Number. In the format of: 47.0
| OS_PLATFORM | String. [Win8, Windows, OS X]
| OS_VERSION | String. [10, 8.1, 8, 7, XP, El Capitan, Yosemite, Mavericks, Mountain Lion, Lion, Snow Leopard]


##### Variables for Video Player running tests

| ENV Variable | Description |
| ------------ | ------------|
| PLAYER_ENVIRONMENT | player/betaplayer/canaryplayer/testplayer. Set the player environment. Default to player.
| PLAYER_BRANCH | true/false. Whether to point to Selenium Grid. False is default if not supplied.
| PLAYER_CHANNEL | String. Set the channel to test against. Default to monstercat.
| PLAYER_DOMAIN | true/false. Send failure alerts to Pagerduty. Default to false.
| PLAYER_TYPE | String. ['', mediaplayer, flash, hls_fallback]
| PLAYER_VOD | String. In the format of: v78264336
| PLAYER_CORE_URL | String. In the format of: http://cvp-web.twitch.tv/origin/develop/
| TEST_SUITE | String. Can be either `player_ui` or `player_core`

##### Gnosis Integration

Details can be found in the [Gnosis Documentation](gnosis.md)

