# Smoca Framework Structure

Smoca can be broken down into three main sections.

    - core - Contains configs, utils, data and page objects
    - spec - Contains the test (features/scenarios) themselves
    - resources - Contains materials relevant to the user on working with Smoca


### Detailed view of CORE and SPEC

CORE contains all the configs, utils, data and page objects

    - network_traffic_analytics - Anything dealing with analytic events
    - api - Anything dealing with apis
    - base - Contains the base files for creating page objects and specs.
             page_helper.rb - Is base helpers that can be utilized on all/most pages on Twitch.
                              This file should be considered a base to be extend on page objects in the future.
             spec_helper.rb - Is required on all spec files.
    - configs - Contains files that deal with the configuration/setup of page/test/spec/utils
    - data - Contains files deal with data used in specs.
    - formatters - Contains Rspec formatters
    - utils - Contains util helpers generally not associated with Twitch but aid in creating detailed test.
    - twitch - Contains Page Object helpers for Twitch associate objects.
        - web - The main category for web based automation testing page objects.
        - video_player - The main category for video player automation and analytics.

SPEC contains all the test specs. Folders and sub-folders contained under spec are the various test cases for Twitch
varying on platform and page breakdown.

    - web - Anything dealing with web pages.
    - video - Anything video player and related video player analytics.
