## Table of Contents
- [SSH into Linux Node](#ssh-into-linux-node)
- [VNC into Linux Grid Node](#vnc-into-linux-grid-node)
- [VNC into Windows Node](#vnc-into-windows-node)

## SSH into Linux Node

You'll need to SSH into the EC2 Instance to be able to run docker commands.

To SSH, run this command, filling in the required variables:
`ssh ldap_username@privateIP`

For example:
`ssh dylan@83.895.388.388`

You can find a machine's private ip through the AWS Console. The boxes are generally named with "selenium"

## VNC into Linux Grid Node

If needed to access VNC, spin up a Debug Node and expose port 5900:5900. You will append `-p 5900:5900`

VNC can be accessed by putting into Safari:
`vnc://PRIVATE_NODE_IP:5900`

The default password for VNC is `secret`

Full example:

```
docker run -d --name firefox_debug -p 5555:5555 -p 5900:5900 \
-e REMOTE_HOST=http://$(echo `curl -s http://169.254.169.254/latest/meta-data/local-ipv4`):5555 \
-e HUB_PORT_4444_TCP_ADDR=grid.us-west2.justin.tv \
-e HUB_PORT_4444_TCP_PORT=80 \
selenium/node-firefox-debug:2.53.0
```

## VNC into Windows Node

In order to connect to the node, you will need the associated private key pair to the instance public key.

1. On AWS, right click on the instance you want to connect to.
2. Click Connect.
3. Click Get Password.
4. Click Choose File and open the .pem file associated with the instance public key.
5. Decrypt the Password
6. Use the Remote Desktop to connect to the instance via its private ip and use the newly decyrpted password to login when prompted.


