## Setting Up Windows Nodes

As of 9/20/2016, Grid is connected to 12 Windows 8 instances

### Table of Contents
- [Manually through AWS](#manually-through-AWS)
- [Select an existing key pair or create a new key pair](#select-an-existing-key-pair-or-create-a-new-key-pair)
- [Setting up Alarms](#setting-up-alarms)
- [Connecting to Grafana](#connecting-to-grafana)
- [Connecting to the Instance](#connecting-to-the-instance)
- [Setting up Windows Environment for Smoca](#setting-up-windows-environment-for-smoca)

### Manually through AWS
From the AWS EC2 Dashboard, click on 'Launch Instance' under the 'Create Instance' section.

Step 1: Choose an Amazon Machine Image (AMI)

- Select the 'Community AMIs' tab on the left hand side.
- In the Search Bar, search for and select:
```
Windows_Server-2012-R2_RTM-English-64Bit-Base-2016.07.26 - ami-2426e944
```

Step 2: Choose an Instance Type

- Scroll down and select:
```
c4.xlarge
```
- Click the 'Next: Configure Instance Details' button on the bottom right hand side to continue.

Step 3: Configure Instance Details

- Configure the following:

|     Key                |                Value                                  |
| ---------------------- |-------------------------------------------------------|
| Network                |```vpc-230f5e46 (10.194.0.0/18) | Development```|
| Subnet                 | ```subnet-b0af88d5(10.194.0.0/21) | Service - A | us-west-2a```|

- Click the 'Next: Add Storage' button on the bottom right and side to continue.

Step 4: Add Storage

- Continue on and click the 'Next: Tag Instance' button on the bottom right hand side to continue.

Step 5: Tag Instance

- Click the 'Create Tag' button two more times and configure the following:

|     Key                |                Value                                  |
| ---------------------- |-------------------------------------------------------|
| Name                   |```selenium-win8-node-prod-[number]```                 |
| Owner                  | ```[ldap]```                                          |
| Team                   | ```qa/smoca```                                        |

- Click the 'Next: Configure Security Group' button on the bottom right hand side to continue.

Step 6: Configure Security Group

- From 'Assign a security group' select 'Select an existing security group'
- Scroll down towards the bottom and select the following:
```
sg-c06b03a4twitch_subnets
```
- Click the 'Review and Launch' button on the bottom right hand side to continue.

Step 7: Review Instance Launch

- Ensure all configurations are correct.
- Click the 'Launch' button on the bottom right hand side to continue.

### Select an existing key pair or create a new key pair

After clicking the 'Launch' button on the bottom right hand side, there should be a prompt to select an existing key pair or create a new key pair.
If the instance is to be connected to Grid for use with Smoca, please contact the QA team for the appropriate key pair.

Assuming a key pair already exist.

- Select 'Choose an existing key pair' from the drop down.
- Then select the key from the drop down under 'Select a key pair'
- After selecting the key, check the 'I acknowledge that I have access to the selected private key file ([key]), and that without this file, I won't be able to log into my instance.' check box.
- Click the 'Launch Instances' button.

A 'Launch Status' page should be displayed, with the instance id in the 'Your instances are now launching' section.
Clicking on the instance id will bring you to the instance being initialized.

Note: To make the rest of setting up the Windows instance easier, copy the newly create instance id.

### Setting up Alarms

From the AWS main dashboard, click on 'CloudWatch' from the 'Management Tools' subsection.

- Click on 'Alarms' on the left hand column.
- Click on 'Create Alarm'
- In the 'Copy Alarm' popup, paste the newly created instance id into the Search Bar and hit Enter.
- Select the 'Metric' named 'CPUUtilization'
- Click the 'Next' button on the bottom right hand side.
- Configure the Alarm as follows:

|     Key                |                Value                                               |
| ---------------------- |--------------------------------------------------------------------|
| Name                   |```selenium-win8-node-prod-[number]-[instance id]-CPU-Utilization```|
| Description            | ```Created from EC2 Console```                                     |
| is                     | ```>=```                      | ```75```                           |
| for                    | ``` 1 ```                                                          |

- Click the '+ Notifications' button under the 'Actions' subcategory and configure the following:

|     Key                |                Value                                               |
| ---------------------- |--------------------------------------------------------------------|
| Whenever this alarm    |```State is OK```                                                   |
| Whenever this alarm    | ```qa-selenium-grid```                                             |

- Click the '+ Notifications' button under the 'Actions' subcategory again and configure the following:

|     Key                |                Value                                               |
| ---------------------- |--------------------------------------------------------------------|
| Whenever this alarm    |```State is ALARM```                                                |
| Whenever this alarm    | ```qa-selenium-grid```                                             |

- Click the 'Create Alarm' button on the bottom right hand side.

### Connecting to Grafana

Hook up the new instance to (Smoca Grafana)[https://grafana.prod.us-west2.justin.tv/dashboard/db/smoca]:

* Grid Average CPU Utilization
* Grid Network Out
* Grid Network In

### Connecting to the Instance

Please see the following for [Connecting to Nodes](https://git-aws.internal.justin.tv/qa/smoca/blob/master/resources/docs/grid/connecting_to_nodes.md).

### Setting up Windows Environment for Smoca

* Update OS with latest security updates.
* Allow Java to communicate through Firewall. Search for "Firewall" in start menu, click "Allow App through Firewall" - The location is something like `C:\ProgramData\Oracle\Java\java_target_#####\java.exe`
* (Disable IE Security)[https://4sysops.com/archives/how-to-disable-internet-explorer-enhanced-security-configuration-ie-esc-in-windows-server-2012/].
* Disable Windows Updates notifications.
* Download/Install Firefox [45.0.2 ESR](https://ftp.mozilla.org/pub/firefox/releases/45.0.2esr/win64/en-US/)
* Download/Install Adobe Flash Player.
* Download/Install Chrome browser.
* Download/Install Java SDK.
* Setup Selenium folder on desktop.
    * Download IEDriver.
    * Download [ChromeDriver 2.33](https://sites.google.com/a/chromium.org/chromedriver/downloads).
    * Download selenium standalone jar ``` selenium-server-standalone-2.53.1.jar ```
    * Create 'command to start' text file with the following:
    
```
PROD
java -jar selenium-server-standalone-2.53.1.jar -role node -hub http://grid.us-west2.justin.tv:80/grid/register -Dwebdriver.chrome.driver=chromedriver.exe -browser browserName=chrome,maxInstances=1 -browser browserName=firefox,maxInstances=1 -Dwebdriver.ie.driver=IEDriverServer.exe -maxSession 1

DEV
java -jar selenium-server-standalone-2.53.1.jar -role node -hub http://grid-dev.us-west2.justin.tv:80/grid/register -Dwebdriver.chrome.driver=chromedriver.exe -browser browserName=chrome,maxInstances=1 -browser browserName=firefox,maxInstances=1 -Dwebdriver.ie.driver=IEDriverServer.exe -maxSession 1
```

#### Windows Server Essentials Media Pack
A change was made where Windows Media Essentials are now required on Windows Server 2012 R2.

1) Open Server Manager
2) In the upper right, click manage, click Add Roles & Features
3) Click Next, set Installation Type to "Role Based or Feature Based Installation"
4) Select the current machine as the destination
5) In "Server Roles" select "Windows Server Essentials Experience"
6) Click next the rest of the way through, let it install

Then download esemp.exe [Windows Server Essentials Media Pack](https://www.microsoft.com/en-us/download/details.aspx?id=40837). Run that installation, restart, and verify Firefox http://loads player.twitch.tv?channel=monstercat



