This documentation covers methods for updating and modifying docker containers for Selenium Grid.

## Via Puppet

When our nodes boot up, they run a cloud-init command to run puppet.

If you intend to make permanent changes to the docker container, it should be modified within puppet.

Our puppet configuration can be found here:
[systems/puppet/modules/twitch_grid](https://git-aws.internal.justin.tv/systems/puppet/tree/master/modules/twitch_grid/)

The Hub and Node manifest images are labeled near the top of the manifest.

After you merge your updates, wait a few minutes for puppet-master to build the new code. Then:
- SSH into the box
- Run `sudo puppet agent --test`

## Via PSSH

#### Installing
`pssh` is a utility that allows you to ssh into multiple machines and run commands.

To install it, run `brew install pssh`

#### Running
Define a file that includes all private IP addresses of the machines you'd like the commands to run on.
I called mine `hosts.conf`. Example:
```
# hosts.conf
10.194.5.22
10.194.5.155
10.194.2.166
```

Define or use an existing script to run on the box. Defined scripts are in
[./resources/scripts/grid_maintenance](../../scripts/grid_maintenance).

Then run a command like:
```
pssh -i --send-input --user dylan --askpass -O StrictHostKeyChecking=no \
-h hosts.conf < ~/twitch/smoca/resources/scripts/grid_maintenance/use_debug_containers.sh
```

Update the above command replacing `--user dylan` with your ldap username.
Also update the path on your machine to the script file you'd like to use.

`-i` allows you to view standard output.
`-O StrictHostKeyChecking=no` will allow you to ssh into machines you haven't logged into before.
`--send-input` allows the script file to run.
`--askpass` will ask for your ssh password.
