This documentation serves to cover the infrastructure that runs Smoca.

It is split up into three different sections:

1. [Jenkins](#jenkins)
2. [Manta](#manta)
3. [Grid](#grid)

# Jenkins
Smoca jobs are run within [Jenkins](https://jenkins.internal.justin.tv/) inside of a Manta Container (more information on [Manta below](#manta)).

### Types of Jobs
There are multiple Jobs defined for Smoca. Read below to understand the differences between each.

##### [qa-smoca](https://jenkins.internal.justin.tv/job/qa-smoca/)

These are full regression tests triggered by developers. qa-smoca can be triggered either from [Skadi](resources/docs/skadi_integration.md), or via its Jenkins Job.

If you are a developer looking to have your branch regression tested, this is the job to run.

##### Smoca Repo Jobs
These jobs include:
- [qa-smoca-build](https://jenkins.internal.justin.tv/job/qa-smoca-build/)
- [qa-smoca-player-ui-ff](https://jenkins.internal.justin.tv/job/qa-smoca-player-ui-ff/)
- [qa-smoca-player-ui-chrome](https://jenkins.internal.justin.tv/job/qa-smoca-player-ui-chrome/)

These tests run whenever code is pushed to the qa/smoca repository. They include the new code within the branch. This serves as a check to ensure no bugs were introduced by a code change.

Whenever opening a PR, you should ensure these tests pass.

![Smoca Build Check](images/smoca_build_check.png)

##### [smoca-player-core](https://jenkins.internal.justin.tv/job/smoca-player-core/)

These are full regression tests triggered by player-core team.


##### [smoca-player-ui](https://jenkins.internal.justin.tv/job/smoca-player-ui/)

These are full regression tests triggered by [smoca-player-ui-suite](https://jenkins.internal.justin.tv/job/smoca-player-ui-suite/).


#####[smoca-player-ui-suite](https://jenkins.internal.justin.tv/job/smoca-player-ui-suite/)

This is a multijob setup to execute a series of video player related automation test. Each phase of the multijob will trigger a build to [smoca-video](https://jenkins.internal.justin.tv/job/smoca-video/) with a set of predefined parameters. As of 8/10/2016, this multijob will trigger two different video player test: Tier 1 tracking validation (uses proxy) and Basic Playback/UI validation (no proxy).

If you are a developer looking to have your branch regression tested, this is the job to run.

### Configuration

We define our Jenkins jobs in code. We do this through a `jenkins.groovy` file, located at the root of the directory.

Jenkins.groovy utilizes the [Job DSL Plugin](https://github.com/jenkinsci/job-dsl-plugin). A full [api viewer](https://jenkinsci.github.io/job-dsl-plugin/) is available for this.

Within all jobs, we define parameters. We then assign export those parameters to a file called `buildenv.sh`. An example is `export TIER2=\$TIER2`.
Manta then loads that file for its parameters. This allows Manta to not have to rebuild its image anytime a parameter changes.

# Manta
[Manta](https://apidocs.joyent.com/manta/index.html) allows for consistent, redistributable containers, so that it's the same environment regardless of the box you're running on.

Our Smoca code runs within manta, and not directly on the Jenkins box.

### Configuration

The Manta configuration exists within `.manta.json` in the root of the directory.

Within it, we define a base image to work off of, in this case, ubuntu.
`"image": "ubuntu:precise",`

Within setup, we define essentials needed to run the suite, such as Firefox.

In the build definition, we give it a command to run `bundle exec rake`, which runs the `Rakefile` within the project.

# Grid

In order to distribute tests efficiently, we utilize a Selenium Grid.

See [Selenium Grid Documentation](grid/README.md)
