# PagerDuty Incident: Session was terminated due to \[CLIENT_GONE, CLIENT_TIMEOUT\]

### Incident Detail

#### Symptoms

Exceptions such as:
- `Session [383ee974-b1b4-4e85-8a60-b414d5e43df8] was terminated due to CLIENT_GONE (org.openqa.grid.common.exception.GridException)`

Smoca Jobs will be disconnected from the Grid, and may fail.

#### Likelihood of Occurrence

Low

#### Example

https://twitchoncall.pagerduty.com/incidents/P4WLQV9

### Cause

Errors like `CLIENT_GONE`, `CLIENT_TIMEOUT` are often Selenium Grid networking issues. These sometimes temporarily blip, but should resolve on the next run.

If they don't, something may be timing out. This seems to correlate with Level 3 issues, but the cause is somewhat unknown.

### Resolution

If this occurs over a long period of time, it's recommended to move the node to debug, and [VNC into it](/resources/docs/grid/connecting_to_nodes.md).

Browsers may be getting stuck on a request, and that request may be in the lower left corner of the browser.

You could also try enabling Network Tab when VNC'd and see if you can catch what request is failing.

There is no concrete resolution available at this time.
