# PagerDuty Incident: API request error

### Incident Detail

#### Symptoms

Exception such as:
```
API request error.
	Endpoint: DELETE https://api.twitch.tv/kraken/users/qa_auto_following/follows/channels/qa_global_emails_off
	Response Code: 500
```

#### Likelihood of Occurrence

Medium

#### Example

https://twitchoncall.pagerduty.com/incidents/PBZTG6R

### Cause

Response Codes:

- 500 Internal Server Error
  - This is a production or networking issue! [Escalate to API On-Call](/resources/docs/on_call_runbook/README.md#escalating-to-engineering-on-call).
- 422 Unprocessable Entity
  - User was already following this user. Likely an issue with Smoca & Concurrency

### Resolution

If a 500, there's nothing we can do to resolve. This must be investigated by the API Team.

If a 422, Smoca was already following that user. This generally shouldn't make it to PagerDuty, but if it does, look into issues of concurrency.
