# PagerDuty Incident: Expected To Find

### Incident Detail

#### Symptoms

Smoca job fails with an exception like:

- `expected to find css ".cn-metabar__livecount" but there were no matches`
- `expected to find css "#top-channels .stream" 6 times, found 5 matches`
- `Unable to find link "Sign Up"`
- `expected: > 10 got: 0`

#### Likelihood of Occurrence

High

#### Example

https://twitchoncall.pagerduty.com/incidents/P4TZ0MM

### Cause

This exception is raised whenever a Capybara & RSpec Exception is raised. The feature is not working as expected.

It generally means there is something either missing or incorrect on the website. Possibilities as to why this may occur:
- Twitch Production Issue
- Elements may have changed

### Resolution

Take a look at the screenshot provided near the bottom of the Jenkins Log. This will give you a good idea of what's going on.

If the test scenario isn't clear what it's testing, look at the back trace and read through the code to understand the scenario and what's expected.

Try it yourself. If the scenario is "Can log in through modal", try going to a channel and clicking Log In, and going through the flow.

Try replicating locally through Smoca. See the documentation [Replicating Locally](../../../understanding_test_output.md#replicating-locally)


**If you encounter the feature not working as it's expected, begin steps to triage to an [engineering on-call](/resources/docs/on_call_runbook/README.md#escalating-to-engineering-on-call)**

If the issue is simply in Smoca (perhaps an element's class name changed), you can either begin steps to update the test, or throw it out using `skip`
