# PagerDuty Incident: Timed out waiting for page load

### Incident Detail

#### Symptoms

Example of an exception:
```
  Timed out waiting for page load.
Build info: version: '2.53.1', revision: 'a36b8b1', time: '2016-06-30 17:37:03'
System info: host: 'fc44e686c0e9', ip: '172.17.0.2', os.name: 'Linux', os.arch: 'amd64', os.version: '3.13.0-92-generic', java.version: '1.8.0_91'
Driver info: driver.version: unknown (org.openqa.selenium.TimeoutException)
```

#### Likelihood of Occurrence

Low

#### Example

https://twitchoncall.pagerduty.com/incidents/PHD2E8H

### Cause

There's a request timing out, and Selenium is unable to detect the page has finished loading.

### Resolution

If this occurs over a long period of time, it's recommended to move the node to debug, and [VNC into it](/resources/docs/grid/connecting_to_nodes.md).

Browsers may be getting stuck on a request, and that request may be in the lower left corner of the browser.

You could also try enabling Network Tab when VNC'd and see if you can catch what request is failing.

There is no concrete resolution available at this time.
