This Documentation will cover Smoca Player-UI Test Suite.
Player-UI test runs against environments like `player.twitch.tv`.

**NOTE: To run a player-ui test `TEST_SUITE=player_ui` is required. It is also the default on `video_player_config.yaml`.**

### Table of Contents
- [Tier 1 Tracking Events](#tier-1-tracking-events)
- [Playback](#playback)
- [UI](#ui)
- [Channel Page](#channel-page)

# Tier 1 Tracking Events
Tier 1 Tracking events consist of validating 4 main events:
- video-play
- minute-watched
- buffer-empty
- buffer-refill

This test can be found in [tier1_tracking_spec.rb](https://git-aws.internal.justin.tv/qa/smoca/blob/master/spec/video/player_ui/stream/tier1_events/tier1_tracking_spec.rb) and is only currently avaliable for Steam testing.

#### Tracking event: video-play
Validation of this video-play is through a recording of the network traffic ([HAR file](https://github.com/lightbody/browsermob-proxy)) when the player is running for 20 seconds. The HAR is filtered for spade events with a decoded response that match the event name 'video-play'.

Duplicates of this event will result in a failed test.

#### Tracking event: minute-watched
Validation of minute-watched is through a recording of the network traffic ([HAR file](https://github.com/lightbody/browsermob-proxy)) when the player is running for 120 seconds. The HAR is filtered for spade events with a decoded response event name 'minute-watched' and have attributes 'minutes-logged' equal to the values of '1' and '2' respectively.

A minute-watched event with out of order minutes-logged or minutes-logged greater than 2 will result in a failed test.

#### Tracking event: buffer-empty (Not currently part of TEST_SUITE=player_ui)
Validation of buffer-empty is through a recording of the network traffic ([HAR file](https://github.com/lightbody/browsermob-proxy)) when the player is running for a total of 60 seconds. Browsermob Proxy is used to limit the bandwidth by adding a 5 second latency to the player. The HAR is filtered for spade events with a decoded response event name 'buffer-empty'.

#### Tracking event: buffer-refill (Not currently part of TEST_SUITE=player_ui)
Validation of buffer-refill is through a recording of the network traffic ([HAR file](https://github.com/lightbody/browsermob-proxy)) when the player is running for a total of 90 seconds. Browsermob Proxy is used to limit the bandwidth by adding 5 seconds latency to the player. Before the last 30 seconds of the test Browsermob Proxy is used to reset the bandwidth limit back to 0 latency. The HAR is filtered for spade events with a decoded response event name 'buffer-refill'.

**NOTE: Tracking buffer-empty and buffer-refill require an additional parameter to run, and will run as a solo job due to issues with throttling.** To run a buffer event test set `BUFFER_EVENT=buffer_empty` or `BUFFER_EVENT=buffer_refill` on the command line like so:
`PROPERTIES=video_player_config.yaml BUFFER_EVENT=buffer_empty TEST_SUITE=player_ui bundle exec rake`

# Playback
Playback test consist of validating specific events (`playing`, `paused`) through javascript callbacks.

Playback test for Streams can be found in [stream/playback_spec.rb](https://git-aws.internal.justin.tv/qa/smoca/blob/master/spec/video/player_ui/stream/playback_spec.rb).
Playback test for VODs can be found in [vod/playback_spec.rb](https://git-aws.internal.justin.tv/qa/smoca/blob/master/spec/video/player_ui/vod/playback_spec.rb).

#UI
UI test consist of validating specific ui elements.

UI test for Streams can be found in [stream/ui_spec.rb](https://git-aws.internal.justin.tv/qa/smoca/blob/master/spec/video/player_ui/stream/ui_spec.rb).
UI test for VODs can be found in [vod/ui_spec.rb](https://git-aws.internal.justin.tv/qa/smoca/blob/master/spec/video/player_ui/vod/ui_spec.rb).

# Channel Page
Channel Page test consist of simple player UI validations on a channel page. It is currently only triggered on `PLAYER_TYPE=player` builds.

Channel Page test can be found in [stream/channel_player/channel_page_spec.rb](https://git-aws.internal.justin.tv/qa/smoca/blob/master/spec/video/player_ui/stream/channel_player/channel_player_spec.rb).