# Skadi Integration

Smoca is able to be triggered directly from [Skadi, our internal deploy tool](https://clean-deploy.internal.justin.tv/).

If supported, while deploying a branch to an environment, you are given the option to run Smoca after the deploy.

![Image of Deploy Tool](https://git-aws.internal.justin.tv/github-enterprise-assets/0000/0178/0000/0227/b3b75bc6-a586-11e5-9d27-5101271182bf.png)

### Working with Multiple Branches

Often a developer may have both a web and web-client branch that must be deployed to an environment together.

It's vital that you **only toggle Smoca on the last branch you deploy to that environment**. Failure to do so will result in multiple Smoca builds. The environment may also briefly blip upon deploy of the next branch, potentially causing failures in the Smoca run.

### Supported Repositories
Currently known:

- web/web

### FAQ

**Does this affect build time, or block builds from completing?**
No. This is a part of the deploy job, and has nothing to do with the build process.

**Does this increase the time it takes to deploy a branch?**
No. Smoca is triggered after the deploy is complete, so it has no effect on the actual timing of the deploy.

**How can I see the results of my Smoca Build?**
See [Getting Smoca Results](../../README.md) on the README.

**How do I debug failed tests?**
Failures will output to the bottom of the log, including the exact line/expectation that failed. I’d recommend you try replicating the test case manually.

**Should I run Smoca when I deploy master to production?**
It won't hurt. If you are pushing an emergency fix straight to production, running the full suite can give you some coverage to ensure no regressions were introduced.


# Adding Smoca to your Repository

The following files need to be edited for Smoca Support:

1. Deploy.json
2. Jenkins.groovy


#### Deploy.json

Within the project's deploy.json, smoca must be added to the json object, with the following boolean fields:

|     Boolean Field         |     Description      |
|----------------------|--------------------- |
| hidden         | If the checkbox should appear or not. If true, Smoca will always run. |
| opt_out | Whether the toggle is opt-in or opt-out. If true, the checkbox defaults to toggled. |

If smoca is not defined within the deploy.json, Smoca will never run.

Example:

```
"smoca": {
	"hidden": false,
	"opt_out": false
}
```

This will display the checkbox, with the check box unchecked by default.

#### Jenkins.groovy

Within a Jenkins Deploy Job, it must be defined to trigger qa-smoca downstream.

The following must be added:

```
parameters {
    booleanParam('TRIGGER_SMOCA', false)
    stringParam('GITHUB_CREATOR', '')
}

steps {
    conditionalSteps {
      condition {
        booleanCondition('$TRIGGER_SMOCA')
      }
      runner('Fail')
      steps {
        downstreamParameterized {
          trigger('qa-smoca', 'ALWAYS') {
            parameters {
              currentBuild()
            }
          }
        }
      }
    }
}
```

*(Note: This should not override any pre-defined parameters or steps. A project should have additional steps for the deploy).*
