## About

[Terraform](https://www.terraform.io/) is a tool for building, changing and versioning our infastructure safely and efficiently. For Smoca, this allows us to quickly spin up the hub and nodes that form our automation grid.

## Features and Usage

- Infrastructure as Code: Infrastructure is described using a high-level configuration syntax. This allows a blueprint of your datacenter to be versioned and treated as you would any other code. Additionally, infrastructure can be shared and re-used.
- Execution Plans: Terraform has a "planning" step where it generates an execution plan. The execution plan shows what Terraform will do when you call apply. This lets you avoid any surprises when Terraform manipulates infrastructure.
- Resource Graph: Terraform builds a graph of all your resources, and parallelizes the creation and modification of any non-dependent resources. Because of this, Terraform builds infrastructure as efficiently as possible, and operators get insight into dependencies in their infrastructure.
- Change Automation: Complex changesets can be applied to your infrastructure with minimal human interaction. With the previously mentioned execution plan and resource graph, you know exactly what Terraform will change and in what order, avoiding many possible human errors.

## Windows Nodes

In order to be able to connect to a windows node the instance has to be created with a key-pairing. As of 8/11/2016, QA does not have a team key-pair for this kind of setup.
On creation the node was given a public key.

For more resources on setting up a key-pairing for windows instances see the following:

- [AWS_KEY_PAIR](https://www.terraform.io/docs/providers/aws/r/key_pair.html)
- [Retrieving the Public Key for Your Key Pair on Windows](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)

