This documentation serves to educate readers on understanding Smoca's output, as well as debugging failures.

When Smoca starts, you will see the URL Environment it is running against print to the top.

As tests run, you will see output on if they passed or failed in real-time. At the end of the test, a summary on failed scenarios will be printed.

#### Test Color Key

- Green: Test passed
- Yellow: Test is set to skip within Smoca
  - Often has a comment attached as to why it was set to skip
- Red: Test Failed

## Debugging Failed Tests

When Smoca fails, it's best to try and replicate the issue manually.


Failed scenarios generally output to the bottom of the logs. There are three primary parts that should be looked at:

- The scenario being tested
- The expectation that generated the failure
- The screenshot

![Smoca Build Check](images/failed_output_layout.png)

In the example above, we can see that the scenario is that the chat column loads with dark theme. The failure was that the `.js-chat-container` CSS was not found.

**Note:** The `Errno::ECONNREFUSED` may look like a bug with the Smoca framework, but that is unrelated to the failure. This is printed upon every failure.

You can also look at the stack trace and lead back to the failing spec. We can see in the above example the spec is: `./spec/web/chat_spec.rb:11` (line 11).

#### Replicating Locally
If you clone Smoca locally and run `ENVIRONMENT=YOUR_STAGING_ENVIRONMENT bundle exec rspec ./spec/web/chat_spec.rb:11` you may be able to replicate locally. You can also examine the code to see what accounts Smoca is using, what page it is visiting, etc.

For more information on running Smoca locally, see [the "Locally" section on README.md](../../README.md#locally).


#### Determining Source of the Issue

After replicating the issue, it's often helpful to deploy masters to the environment and try again to replicate. This can help determine if it's an environment issue, or if it's something introduced by your branch.
