#!/bin/bash
set -e

usage() {
    echo "Usage: $(basename $0) -p <PR#> -t <GITHUB_ACCESS_TOKEN> -c <comment> -r <REPO> -o <OWNER>" 1>&2
    exit 1
}

while getopts ":t:c:r:o:p:" i; do
  case "${i}" in
    t)
        GH_ACCESS_TOKEN=${OPTARG}
        ;;
    c)
        COMMENT=${OPTARG}
        ;;
    r)
        REPO=${OPTARG}
        ;;
    o)
        OWNER=${OPTARG}
        ;;
    p)
        PR=${OPTARG}
        ;;
    *)
        usage
        ;;
  esac
done

shift $((OPTIND-1))

if [ -z "$GH_ACCESS_TOKEN" ] || [ -z "$COMMENT" ] || [ -z "$OWNER" ] || [ -z "$REPO" ] || [ -z $PR ]; then
    usage
fi

curl "https://git-aws.internal.justin.tv/api/v3/repos/$OWNER/$REPO/issues/${PR}/comments" \
    -H "Content-Type: application/json" \
    -H  "Authorization: token ${GITHUB_ACCESS_TOKEN}" \
    -X "POST" \
    -k \
    -d "{\"body\": \"$COMMENT\"}"
