require './core/base/spec_helper'
require './core/twitch/video_player/player_page'

feature "Channel Page Integration" do
  HOST = 'https://staging-dev-env-1-www.dev.us-west2.twitch.tv'
  STREAM = 'twitchmedia2'

  before(:each) do
    player_url = "#{HOST}/#{STREAM}"
    visit player_url
    page.execute_script(set_local_storage)
    expect(page).to have_css('video', wait: 45)
    page.execute_script "$('.js-main-col-scroll-content')[0].scrollTop += 200"
  end

  scenario "should have all player buttons" do
    expect(PlayerPage.play_pause_btn_present?).to eq(true)
    expect(PlayerPage.volume_btn_present?).to eq(true)
    expect(PlayerPage.options_btn_present?).to eq(true)
    expect(PlayerPage.fullscreen_btn_present?).to eq(true)
    expect(PlayerPage.twitch_logo_btn_present?).to eq(true)
    expect(PlayerPage.player_div_present?).to eq(true)
    expect(PlayerPage.player_controls_bottom_present?).to eq(true)
    expect(PlayerPage.theatremode_btn_present?).to eq(true)
  end

  scenario "should start playing content" do
    has_played = PlayerPage.execute_async_script(on_playing, 30)
    expect(has_played).to eq(true)
  end

  scenario "should fullscreen/exit fullscreen" do
    skip('Not working on Firefox or IE11')
    PlayerPage.click_fullscreen_btn

    expect(PlayerPage.player_fullscreen?).to eq(true)

    PlayerPage.double_click_player
    PlayerPage.send_esc_key

    expect(PlayerPage.player_fullscreen?).to eq(false)
  end

  scenario "shows play button overlay when paused" do
    PlayerPage.click_play_pause_btn
    expect(PlayerPage.play_btn_overlay_css?).to eq(true)
    PlayerPage.click_overlay_play_btn
    expect(PlayerPage.no_play_btn_overlay_css?).to eq(true)
  end

  scenario "should theatremode" do
    expect(PlayerPage.no_theatre_mode?).to eq(true)
    PlayerPage.click_theatremode_btn
    expect(PlayerPage.no_theatre_mode?).to eq(false)
  end

  # JS Scripts

  def set_local_storage
    return "
    if (typeof localStorage !== 'object') return;
      try {
        localStorage.setItem('lastAdDisplay', 999999999999999);
        localStorage.setItem('quality-bitrate', 358879);
        } catch(e) {}
        "
  end

  def on_playing
    return "
        var done = arguments[arguments.length - 1];
        (function() {
          var videoTag = $('video')[0];

          if (!videoTag) {
            return done('Video Tag Not Found')
          }

          videoTag.addEventListener('playing', function() {
            done(true);
            });

            var timeout = setTimeout(function() {
              clearTimeout(timeout)
              var pausedState = 'Paused: ' + videoTag.paused;
              var networkState = 'networkState: ' + videoTag.networkState;
              var readyState = 'readyState: ' + videoTag.readyState;

              // If playing event didn't fire, check ready and paused state
              if (videoTag.readyState > 2 && !videoTag.paused) {
                return done(true);
              }

              done(
              'playing event timed out' +
              [pausedState, networkState, readyState].join(', ')
              );
              }, 20000);
              })();
              "
  end
end
