require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature 'ABS enabled' do

  let(:player_url) { PlayerCoreData.player_core_url }
  let(:quality_names) { PlayerCore.get_qualities_name }
  let(:low_quality) { quality_names[-2] } # Second last quality

  scenario 'verify resolution for high quality when ABS enabled for Live stream', :unsupported_browsers => [:internet_explorer, :firefox] do
    # Skipped on Firefox : CVP-1753
    visit player_url
    expect(PlayerCore).to have_video_container
    expect(PlayerCore.stream_started?).to be_truthy
    expect(PlayerCore.set_quality?(low_quality)).to be_truthy
    expect(PlayerCore.abs_quality_change?).to be_truthy
    # Verify qaulity increased ie current quality > low quality at -2 position
    expect(quality_names[0..-3]).to include(PlayerCore.current_quality['name'])
  end
end
