require './core/base/spec_helper'
require './core/twitch/video_player/player_core'
require './core/utils/browser_utils'

feature 'Background playback' do

  let(:player_url) { PlayerCoreData.player_core_url }
  let(:time) { 10 }

  # Skipped for firefox because Time taken to switch between tabs is large
  # This fails the assertion as new_playhead increase
  scenario 'Ensure playback when tab is in background', :unsupported_browsers => [:firefox] do
    skip 'ToDo Fix QE-1139'
    visit player_url
    expect(PlayerCore).to have_video_container
    expect(PlayerCore.stream_started?).to be_truthy
    old_playhead = PlayerCore.current_playhead
    # Switch to new window and wait for 10 seconds
    within_new_tab { sleep time }
    new_playhead = PlayerCore.current_playhead
    expect(new_playhead).to be_within(1).of(old_playhead + time)
  end
end
