require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

# quality_change_spec.rb is currently setup to only accept the following:
# channel: monstercat
# IMPORTANT: qualities options will vary depending on the the video.
feature 'Test Channel \'food\'' do
  let(:player_url) { PlayerCoreData.player_core_url }
  let(:food_channel) { "#{VideoPlayerData.player_domain_url}/food" }
  let(:quality_names) { PlayerCore.get_qualities_name }
  let(:source) { quality_names[0] }
  let(:low) { quality_names[-2] }

  before(:each) do
    visit player_url
    expect(PlayerCore.video_container).to be_truthy
    expect(PlayerCore.stream_started?(food_channel)).to be_truthy
  end

  scenario "has valid resolution with its height", :unsupported_browsers => [:firefox] do
    PlayerCore.available_quality_options.each do |quality|
      # Test has been flaky and need investigation
      skip("CVP-1777")
      expect(PlayerCore.set_quality?(quality.text)).to be_truthy
      curr_quality = PlayerCore.current_quality
      expect(curr_quality['name'].to_i).to eql(curr_quality['height'].to_i)
    end
  end

  scenario 'can switch to Source quality after switch to Low quality' do
    PlayerCore.set_quality?(low)
    expect(PlayerCore.current_quality['name']).to eq(low)

    PlayerCore.set_quality?(source)
    expect(PlayerCore.current_quality['name']).to include(source)
  end

  scenario 'Plays smoothly - Validate smooth playhead for 20 seconds' do
    expect(PlayerCore.smooth_playhead?(20)).to be_truthy
  end

  scenario 'Plays smoothly - Validate smooth fps for 30 seconds' do
    skip 'FPS is not constant and is falling beyond the expected range'
    expect(PlayerCore.smooth_fps?(30, 30)).to be_truthy
  end
end
