require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature 'network profile events' do

  let(:player_url) { PlayerCoreData.player_core_url }

  scenario "can get a valid stats for network profile events" do
    visit player_url
    expect(PlayerCore).to have_video_container
    expect(PlayerCore.stream_started?).to be_truthy
    network_stats = PlayerCore.network_stats
    expect(PlayerCore.valid_network_stats?(network_stats[0..10])).to be_truthy
  end
end
