require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature 'Player page' do

  let(:player_url) { PlayerCoreData.player_core_url }
  let(:online_stream) {  "#{VideoPlayerData.player_domain_url}/monstercat" }
  let(:offline_stream) { "#{VideoPlayerData.player_domain_url}/qa_auto_offline" }
  let(:offline_error_message) { 'ErrorNotAvailable' }

  before(:each) do
    visit player_url
    expect(PlayerCore).to have_video_container
    expect(PlayerCore.stream_started?).to be_truthy
  end

  scenario 'gives error when playing an offline stream channel' do
    expect(PlayerCore.check_error(offline_stream)['type']).to eql(offline_error_message)
  end

  scenario 'gives no error when playing an online stream channel', :unsupported_browsers => [:internet_explorer] do
    expect(PlayerCore.check_error(online_stream)).to be_falsy
  end
end
