require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature 'Validating streaming ' do
  player_url = PlayerCoreData.player_core_url

  scenario "can be paused and resumed." do
    visit player_url
    # Checking if stream can be paused
    expect(page).to have_css(PlayerCore.video_container)
    expect(PlayerCore.stream_started?).to be_truthy
    expect(PlayerCore.pause?).to be_truthy
    PlayerCore.wait_period(3)
    # player.getPosition() function returns '0' when live stream is paused
    expect(PlayerCore.current_playhead.to_i).to be_eql(0)

    # Checking if stream can be resumed
    PlayerCore.play
    expect(PlayerCore.is_paused?).to be_falsy
    expect(PlayerCore.playhead_changes_with_time?(3)).to be_truthy
  end
end
