require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature 'Validating streaming player-core events:' do
  player_url = PlayerCoreData.player_core_url

  let(:stream_url) { "#{VideoPlayerData.player_domain_url}/#{VideoPlayerData.player_channel}" }
  before(:each) do
    visit player_url
    expect(PlayerCore.stream_started?).to be_truthy
  end

  scenario "'READY' event fired upon stream start." do
    expect(PlayerCore).to have_ready_event(stream_url)
  end

  scenario "'Metadata ID3' event fired 5 times over 30 seconds upon stream start." do
    expect(PlayerCore).to have_metadata_event(stream_url)
  end

  scenario "'player.getPosition' increases as video progresses over a count 20 and 2 seconds wait upon stream start." do
    expect(PlayerCore.smooth_playhead?(20)).to be_truthy
  end

  scenario "Volume level can be changed" do
    visit player_url
    # Checking if stream can be paused
    expect(page).to have_css(PlayerCore.video_container, wait: 5)
    expect(PlayerCore.stream_started?).to be_truthy
    random_volume = rand.round(1) # Rounding off to 1 decimal place
    PlayerCore.set_volume random_volume
    expect(PlayerCore.get_volume).to eq(random_volume)
  end
end
