require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature 'Playback Stats' do

  let(:player_url) { PlayerCoreData.player_core_url }

  scenario 'can get a valid playback stats for Live stream', :unsupported_browsers => [:edge, :internet_explorer] do
    visit player_url
    expect(PlayerCore).to have_video_container
    expect(PlayerCore.stream_started?).to be_truthy

    playback_stats = PlayerCore.playback_stats_values
    playback_stats.each_with_index do |stat, index|
      expect(stat).to be > 0.0, "Expected #{playback_stats[index]} - #{stat} to be > 0 "
    end
  end
end
