require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

# quality_change_spec.rb is currently setup to only accept the following:
# channel: monstercat
# IMPORTANT: qualities options will vary depending on the the video.
feature 'Quality Changed' do
  let(:player_url) { PlayerCoreData.player_core_url }
  let(:quality_names) { PlayerCore.get_qualities_name }
  let(:source) { quality_names[0] }
  let(:medium) { quality_names[quality_names.size / 2] }
  let(:low) { quality_names[-2] }

  before(:each) do
    skip 'Bug ID: CVP-1439 skipped on IE' if page.driver.browser.browser == :internet_explorer
    visit player_url
    expect(PlayerCore.video_container).to be_truthy
    expect(PlayerCore.stream_started?).to be_truthy
  end

  scenario 'loading stream should load default Qualitiy Options' do
    qualities_key_string = PlayerCore.get_quality_list.keys.join
    expect(PlayerCore.quality_dropdown.text).to eq(qualities_key_string)
  end

  scenario 'Switch to Low quality' do
    PlayerCore.set_quality?(low)
    expect(PlayerCore.current_quality['name']).to eq(low)
  end

  scenario 'Switch to Source quality after switch to Low quality' do
    PlayerCore.set_quality?(low)
    expect(PlayerCore.current_quality['name']).to eq(low)

    PlayerCore.set_quality?(source)
    expect(PlayerCore.current_quality['name']).to eq(source)
  end

  scenario 'Interrupt switch to Low quality with Switch to Medium quality', :unsupported_browsers => [:firefox] do
    expect(PlayerCore.set_quality?(low, 0)).to be_falsy

    PlayerCore.set_quality?(medium)
    expect(PlayerCore.current_quality['name']).to eq(medium)
  end
end
