require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature 'Sure Stream' do

  let(:player_url) { PlayerCoreData.player_core_url }
  let(:sure_stream) { "#{VideoPlayerData.player_domain_url}/twitchmedia2" }

  before(:each) do
    visit player_url
    expect(PlayerCore).to have_video_container
  end

  scenario 'have SPLICE_OUT & SPLICE_IN Events WHEN Ad Insertion is Enabled' do
    PlayerCore.ad_insertion_enabled(true)

    expect(PlayerCore.ad_started?(sure_stream)).to be_truthy
    expect(PlayerCore.ad_ended?).to be_truthy
  end

  scenario 'do not have SPLICE_OUT Event WHEN Ad Insertion is Disabled' do
    PlayerCore.ad_insertion_enabled(false)

    expect(PlayerCore.ad_started?(sure_stream)).to be_falsy
  end
end
