require './core/base/spec_helper'
require './core/twitch/video_player/player_core'
require './core/configs/bmp_config'

feature 'Tracking Events - Vaidate event name:' do

  let(:player_url) { PlayerCoreData.player_core_url }
  let(:low_bandwith) { [1000, 5, 5] }
  let(:medium_bandwith) { [2000, 100, 100] }
  let(:high_bandwith) { [0, 30000, 30000] }
  let(:buffer_empty) { 'buffer-empty' }
  let(:buffer_refill) { 'buffer-refill' }
  let(:buffering) { 'Buffering' }

  before(:each) do
    skip 'Execute on prod grid with bmp_enabled' unless bmp_enabled?
    visit player_url
    expect(PlayerCore).to have_video_container
    expect(PlayerCore.stream_started?).to be_truthy
    # Disable ABS
    PlayerCore.enable_abs(false)
    @proxy = get_proxy
    # Throttle Bandwidth
    @proxy.limit_proxy_bandwidth(low_bandwith[0], low_bandwith[1], low_bandwith[2])
  end

  scenario 'LIVE Stream - buffer-empty' do
    # Gather Tracking event data
    @empty_track_event = PlayerCore.tracking_event_data(buffer_empty)
    # Validate PlayerState -> Buffering
    expect(PlayerCore.get_player_state).to eq(buffering)

    # Expect to get both buffer empty event data
    expect(@empty_track_event).not_to be_falsy

    # Validate Buffer empty event properties
    @tracked_event_properties = @empty_track_event['properties']
    expect(@tracked_event_properties['quality']).to eql(PlayerCore.current_quality['name'])
    expect(@tracked_event_properties['stream_format']).to eql(PlayerCore.current_quality['group'])
    expect(@tracked_event_properties['video_height']).to eql(PlayerCore.current_quality['height'])
    expect(@tracked_event_properties['video_width']).to eql(PlayerCore.current_quality['width'])
    expect(@tracked_event_properties['manifest_cluster']).not_to be_empty
    expect(@tracked_event_properties['manifest_node']).not_to be_empty
  end

  scenario 'LIVE STREAM - buffer-refill' do
    expect(PlayerCore.tracking_event_data(buffer_empty)).not_to be_falsy
    # Validate PlayerState -> Buffering
    expect(PlayerCore.get_player_state).to eq(buffering)
    # Removed throttled network.
    @proxy.limit_proxy_bandwidth(medium_bandwith[0], medium_bandwith[1], medium_bandwith[2])

    # Gather Tracking event data
    @refill_track_event = PlayerCore.tracking_event_data(buffer_refill)
    # Expect to get both buffer refill event data
    expect(@refill_track_event).not_to be_falsy

    # Validate Buffer refill event properties
    @tracked_event_properties = @refill_track_event['properties']
    expect(@tracked_event_properties['quality']).to eql(PlayerCore.current_quality['name'])
    expect(@tracked_event_properties['stream_format']).to eql(PlayerCore.current_quality['group'])
    expect(@tracked_event_properties['video_height']).to eql(PlayerCore.current_quality['height'])
    expect(@tracked_event_properties['video_width']).to eql(PlayerCore.current_quality['width'])
    expect(@tracked_event_properties['manifest_cluster']).not_to be_empty
    expect(@tracked_event_properties['manifest_node']).not_to be_empty
  end

  after(:each) do
    @proxy.limit_proxy_bandwidth(high_bandwith[0], high_bandwith[1], high_bandwith[2])
  end
end
