require './core/base/spec_helper'
require './core/configs/bmp_config'
require './core/twitch/video_player/player_core'

player_url = VideoPlayerData.player_stream_url
feature 'Video playback in bad network connection' do
  let(:vod_stream_url) { "#{PlayerCoreData.player_core_domain_for_vod}/videos/#{TwitchUtils.vod_id(VideoPlayerData.player_vod)}.m3u8" }
  before(:all) do
    skip 'Execute on prod grid with bmp_enabled' unless bmp_enabled?
    @proxy = get_proxy
  end

  before(:each) do
    visit player_url
    expect(PlayerCore).to have_video_container
    expect(PlayerCore.stream_started?).to be_truthy
    expect(PlayerCore.stream_started?(vod_stream_url)).to be_truthy
  end

  scenario 'should not stop playback when speed is throttled to 30 kbps for live stream' do
    previous_player_position = PlayerCore.current_playhead
    @proxy.limit_proxy_bandwidth(0, 300, 300) # Keeping latency to 0 seconds, 300 kbps downstream, 300 kbps upstream.
    # stream playing or not
    expect(PlayerCore.stream_playing?).to be_truthy, "expected to return true for playback, got #{PlayerCore.get_player_state}"
    expect(PlayerCore.playhead_changes_with_time?(5)).to be_truthy
    expect(previous_player_position).to be < PlayerCore.current_playhead
  end

  scenario 'should resume playback when speed is throttled to 0 kbps with high latency for live stream and restored', :latency_up => true do
    skip('Failing due to CVP-1426')
    @proxy.limit_proxy_bandwidth(30000, 0, 0) # Adding 30 seconds latency, 0 kbps downstream, 0 kbps upstream.
    PlayerCore.wait_period(PlayerCore.get_buffer_duration) # Waiting for changes to take effect
    expect(PlayerCore.stream_playing?).to be_falsy, "expected to return false for playback, got status: #{PlayerCore.get_player_state}"
    @proxy.limit_proxy_bandwidth(0, 3000, 3000) # Restoring latency to 0 seconds, 3 mbps downstream, 3 mbps upstream.
    expect(PlayerCore.stream_playing?).to be_truthy, "expected to return true for playback, got #{PlayerCore.get_player_state}"
  end

  after(:latency_up => true) do
    @proxy.limit_proxy_bandwidth(0, 3000, 3000) # Restoring latency to 0 seconds, 3 mbps downstream, 3 mbps upstream.
  end
end
