require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature "Bad VOD's playback" do
  player_url = PlayerCoreData.player_core_url
  let(:vod_url) { "#{VideoPlayerData.player_domain_url}/videos/v/4878428" }
  let(:ended_player_state) { 'Ended' }

  scenario "is not interrupted while playing for vod: 4878428", :unsupported_browsers => [:chrome, :edge, :internet_explorer] do
    # BUG CVP-1437 : Skipped for chrome and edge browser
    visit player_url
    expect(page).to have_css(PlayerCore.video_container)
    expect(PlayerCore.stream_started?(vod_url)).to be_truthy
    expect(PlayerCore.stream_ended?(40)).to be_truthy
  end
end
