require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature 'Closed Captions' do

  let(:player_url) { PlayerCoreData.player_core_url }
  let(:vod_url) { "#{PlayerCoreData.player_core_domain_for_vod}/videos/146723357.m3u8" }
  let(:caption_text) { 'THE SHOW WHERE WE TALK ABOUT COOL STUFF.' }
  let(:caption_time) { 35 }

  scenario 'test for metadata events for closed captions' do
    visit player_url
    expect(PlayerCore).to have_video_container
    expect(PlayerCore.stream_started?(vod_url)).to be_truthy
    PlayerCore.includes_closed_captions_text?(caption_text, caption_time)
  end
end
