require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature "Validate Ended event" do
  let(:player_url) { PlayerCoreData.player_core_url }
  let(:vod_url) { "#{PlayerCoreData.player_core_domain_for_vod}/videos/#{TwitchUtils.vod_id(VideoPlayerData.player_vod)}.m3u8" }

  scenario "on seeking at end of video", :unsupported_browsers => [:edge, :internet_explorer] do
    # Skipped on IE and Edge BUG CVP-1437 # Ended event not getting triggered because VOD stuckeed at end
    visit player_url
    expect(PlayerCore).to have_video_container
    expect(PlayerCore.stream_started?(vod_url)).to be_truthy
    expect(PlayerCore.seek_completed?(PlayerCore.stream_duration - 10)).to be_truthy
    expect(PlayerCore.stream_ended?).to be_truthy
  end
end
