require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature 'Validating VOD ' do
  let(:player_url) { PlayerCoreData.player_core_url }
  let(:vod_url) { 'https://captions.twitch.tv/testvods/master.m3u8' }

  before(:each) do
    visit player_url
    expect(PlayerCore).to have_video_container
    expect(PlayerCore.stream_started?).to be_truthy
  end

  scenario "with Ad break plays smoothly - Linear playhead", :unsupported_browsers => [:edge, :internet_explorer] do
    skip("Failing due to CVP-1473")
    # BUG : CVP-1473 for edge and IE
    # Validate playhead of stream at normal playback rate
    PlayerCore.load_and_play(vod_url)
    expect(PlayerCore.smooth_playhead?).to be_truthy
  end

  scenario "with Ad break plays smoothly - Constant FPS", :unsupported_browsers => [:edge, :internet_explorer] do
    # BUG : CVP-1473 for edge and IE
    # validate FPS to be constant
    skip("QE-924")
    PlayerCore.load_and_play(vod_url)
    expect(PlayerCore.smooth_fps?(24)).to be_truthy
  end
end
