require './core/base/spec_helper'
require './core/twitch/video_player/player_core'

feature "Multiple seek calls" do
  player_url = PlayerCoreData.player_core_url
  let(:vod_url) { "#{PlayerCoreData.player_core_domain_for_vod}/videos/#{TwitchUtils.vod_id(VideoPlayerData.player_vod)}.m3u8" }

  scenario "should result in playback from the last seek call" do
    visit player_url
    expect(PlayerCore.stream_started?(vod_url)).to be_truthy
    expect(PlayerCore.last_seek_completed?).to be_truthy
    expect(PlayerCore.stream_playing?(10)).to be_truthy
  end
end
